/*
 * Decompiled with CFR 0.152.
 */
package view;

import app.FitDataSet;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import util.Logger;
import view.MainView;

public class CorrAlgoDialog
extends JDialog {
    static Logger logger = Logger.getLogger();
    private static final long serialVersionUID = 1L;
    private FitDataSet myFitDataSet;
    private Action confirmAction;
    private Action cancelAction;
    private JRadioButton AlgoSlopeRadio;
    private JRadioButton AlgoAmbiRadio;
    private JRadioButton AlgoFourierRadio;
    private JTextField MinSlopeField;
    private JTextField MaxSlopeField;

    public CorrAlgoDialog(FitDataSet pFDS, MainView pmw) {
        super(pmw, "Select Correction Algorithm", true);
        logger.entry(4, "CorrAlgoDialog.CorrAlgoDialog");
        this.myFitDataSet = pFDS;
        this.createActions();
        this.createControls();
        if (this.myFitDataSet.getCorrAlgo().equals("Slope")) {
            this.AlgoSlopeRadio.setSelected(true);
        } else if (this.myFitDataSet.getCorrAlgo().equals("Ambi")) {
            this.AlgoAmbiRadio.setSelected(true);
        } else {
            this.AlgoFourierRadio.setSelected(true);
        }
        this.pack();
        logger.exit(4, "CorrAlgoDialog.CorrAlgoDialog");
    }

    private void createActions() {
        logger.entry(4, "CorrAlgoDialog.createActions");
        this.confirmAction = new AbstractAction("O.K."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CorrAlgoDialog.this.confirm();
            }
        };
        this.cancelAction = new AbstractAction("Cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CorrAlgoDialog.this.setVisible(false);
            }
        };
        logger.exit(4, "CorrAlgoDialog.createActions");
    }

    private void createControls() {
        logger.entry(4, "CorrAlgoDialog.createControls");
        JPanel controlpanel = new JPanel();
        controlpanel.setLayout(new BoxLayout(controlpanel, 1));
        JPanel SlopePanel = new JPanel();
        SlopePanel.setLayout(new FlowLayout(0));
        SlopePanel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        JPanel SlopeBorderPanel = new JPanel();
        SlopeBorderPanel.setLayout(new BoxLayout(SlopeBorderPanel, 0));
        SlopeBorderPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        SlopeBorderPanel.add(SlopePanel);
        JPanel AmbiPanel = new JPanel();
        AmbiPanel.setLayout(new FlowLayout(0));
        AmbiPanel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        JPanel AmbiBorderPanel = new JPanel();
        AmbiBorderPanel.setLayout(new BoxLayout(AmbiBorderPanel, 0));
        AmbiBorderPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AmbiBorderPanel.add(AmbiPanel);
        JPanel FourierPanel = new JPanel();
        FourierPanel.setLayout(new FlowLayout(0));
        FourierPanel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        JPanel FourierBorderPanel = new JPanel();
        FourierBorderPanel.setLayout(new BoxLayout(FourierBorderPanel, 0));
        FourierBorderPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        FourierBorderPanel.add(FourierPanel);
        controlpanel.add(SlopeBorderPanel);
        controlpanel.add(AmbiBorderPanel);
        controlpanel.add(FourierBorderPanel);
        this.AlgoSlopeRadio = new JRadioButton("Slope Limits", true);
        this.AlgoAmbiRadio = new JRadioButton("Minimal Ambiguity Remove");
        this.AlgoFourierRadio = new JRadioButton("Fourier Algorithm");
        ItemListener AlgoRadioListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CorrAlgoDialog.this.AlgoRadioChanged();
            }
        };
        this.AlgoSlopeRadio.addItemListener(AlgoRadioListener);
        ButtonGroup g = new ButtonGroup();
        g.add(this.AlgoSlopeRadio);
        g.add(this.AlgoAmbiRadio);
        g.add(this.AlgoFourierRadio);
        SlopePanel.add(this.AlgoSlopeRadio);
        AmbiPanel.add(this.AlgoAmbiRadio);
        FourierPanel.add(this.AlgoFourierRadio);
        SlopePanel.add(new JLabel("min: "));
        this.MinSlopeField = new JTextField(String.valueOf(this.myFitDataSet.getMinSlope()));
        SlopePanel.add(this.MinSlopeField);
        SlopePanel.add(new JLabel("max: "));
        this.MaxSlopeField = new JTextField(String.valueOf(this.myFitDataSet.getMaxSlope()));
        SlopePanel.add(this.MaxSlopeField);
        JPanel acceptpanel = new JPanel(new GridLayout(0, 2, 5, 5));
        JButton OkButton = new JButton(this.confirmAction);
        JButton CancelButton = new JButton(this.cancelAction);
        acceptpanel.add(OkButton);
        acceptpanel.add(CancelButton);
        acceptpanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        controlpanel.add(acceptpanel);
        this.add(controlpanel);
        logger.exit(4, "CorrAlgoDialog.createControls");
    }

    private void AlgoRadioChanged() {
        logger.entry(4, "CorrAlgoDialog.AlgoRadioChanged");
        logger.exit(4, "CorrAlgoDialog.AlgoRadioChanged");
    }

    private void confirm() {
        logger.entry(4, "CorrAlgoDialog.confirm");
        if (this.AlgoSlopeRadio.isSelected()) {
            this.myFitDataSet.setCorrAlgo("Slope");
            this.myFitDataSet.setSlopeLimits(Double.valueOf(this.MinSlopeField.getText()), Double.valueOf(this.MaxSlopeField.getText()));
        } else if (this.AlgoAmbiRadio.isSelected()) {
            this.myFitDataSet.setCorrAlgo("Ambi");
        } else {
            this.myFitDataSet.setCorrAlgo("Fourier");
        }
        this.setVisible(false);
        logger.exit(4, "CorrAlgoDialog.confirm");
    }
}

